<?php

namespace App\Http\Resources\Api\Admin;

use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SubCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'parent_id' => $this->parent_id,
            'main_category_id' => $this->main_category_id,
            'image' => MediaResource::make($this->image),

            'category' => $this->parent?->name,
            'main_category' => $this->MainCategory?->name,

            // 'sub_categories' => SubCategoryResource::collection($this->whenLoaded('children'))

        ];
    }
}
