<?php

namespace App\Http\Resources\Api\vendor;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'qty' => $this->rfq->qty,
            'status' => $this->status,

            'created_at' => Carbon::parse($this->created_at)->format('y-m-d'),
            'payment_method' => $this->payment_method,
            'bank_image' => MediaResource::make($this->image),

            'product' => $this->whenLoaded('product', function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'image' => MediaResource::make($this->product->image), // Accessor for image
                ];
            }),
            'specs' => $this->whenLoaded('rfq', function () {
                return $this->rfq->specs->map(function ($spec) {
                    return [
                        'id' => $spec->id,
                        'key' => $spec->key,
                        'value' => $spec->value,
                    ];
                });
            }),
            'branch' => $this->whenLoaded('branch', function () {
                return [
                    'id' => $this->branch->id,
                    'location' => $this->branch->location,
                ];
            }),
        ];
    }
}
