<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class BlogsTranslation extends Model
{
	protected $table = 'blogs_translations';
	public $timestamps = false;

	protected $casts = [
		'blog_id' => 'int'
	];

	protected $fillable = [
		'blog_id',
		'title',
		'description',
		'locale'
	];

	public function blog()
	{
		return $this->belongsTo(Blog::class);
	}
}
