<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RfqItem extends Model
{
    use HasFactory;

        // Fillable properties
        protected $fillable = [
            'rfq_id',
            'product_id',
            'qty',
            'specs'
        ];

        // Relationships

        // An order item belongs to an order
        public function rfq()
        {
            return $this->belongsTo(RFQ::class);
        }

        // An order item belongs to a product
        public function product()
        {
            return $this->belongsTo(Product::class);
        }
}
