<?php

namespace App\Notifications\Channels;

use App\Services\FcmService;

class FcmChannel
{
    public function __construct(private FcmService $fcmService) {}

    public function send($notifiable, $notification)
    {
        $tokens = $notifiable->fcmTokens->pluck('device_token')->toArray();

        $notificationData = $notification->toFcm($notifiable);

        $title = $notificationData['title'] ?? '';
        $body = $notificationData['body'] ?? '';
        $data = $notificationData['data'] ?? [];

        foreach ($tokens as $token) {
            $this->fcmService->send($token, $title, $body, $data);
        }
    }
}
