<?php

namespace App\Http\Resources\Api\Dentist;

use App\helpers\Attachment;
use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;

class RfqBidResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'rfq_id' => $this->rfq_id,
            'qty' => $this->rfq->qty,
            'price' => Attachment::convertPrice($this->price),
            'is_approved' => $this->is_approved,
            'product' => [
                'id' => $this->rfq->product->id,
                'name' => $this->rfq->product->name,
                'image' =>MediaResource::make($this->rfq->product->image),

            ],
        ];
    }
}
