<?php

namespace App\Http\Resources\Api\vendor;

use App\helpers\Attachment;
use App\Http\Requests\Api\vendor\SubCategoryRequest;
use App\Http\Resources\MediaResource;
use App\Models\Category;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'main_category' => CategoryResource::make($this->whenLoaded('mainCategory')),
            'sub_category' => SubCategoryResource::make($this->whenLoaded('subCategory')),
            'category_hierarchy' => $this->when($request->routeIs('products.show') , CategoryResource::collection($this->getCategoryHierarchy())), // Full category hierarchy

            'image' => MediaResource::make($this->image),
            'price' => Attachment::convertPrice($this->price),

            'specs' => $this->specs,
            // 'created_at' => $this->created_at->toDateTimeString(),
            // 'updated_at' => $this->updated_at->toDateTimeString(),
        ];
    }

    private function getCategoryHierarchy()
    {
        $categories = [];

        // If sub_category_id is null, return only the main category
        if (is_null($this->sub_category_id)) {
            if ($this->mainCategory) {
                $categories[] = $this->mainCategory;
            }
        } else {
            // Start with the subcategory (the lowest child)
            $currentCategory = $this->subCategory;

            // Traverse up to the top parent
            while ($currentCategory) {
                $categories[] = $currentCategory; // Add the current category to the list
                $currentCategory = $currentCategory->parent; // Move to the parent
            }

            // Reverse the categories array to have the highest parent first
            $categories = array_reverse($categories);
        }

        return $categories;
    }
}
