<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymobPaymentTracker extends Model
{
    use HasFactory;
    protected $fillable = [
        'order_id',
        'reference_id',
        'user_id',
        'currency_id',
        'payment_method_id',
        'transaction_id',
        'amount',
        'status',
        'message',
        'payload',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

}
