<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'owner_name' => 'required|max:250',
            'country_code' => 'required',
            'email' => 'required|email|unique:users,email',
            'country_id' => 'required',
            'password' => 'required|confirmed|max:64',
            'mobile' => 'required|unique:users,mobile|numeric|min:15',
            'type' => 'required|in:dentist,vendor',
        ];



        return $rules;
    }

}
