<?php

use App\Models\Country;
use Illuminate\Http\Request;
use App\Models\CountryTranslation;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Contracts\Role;
use App\Http\Resources\CountryResource;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Resources\Api\Dentist\RfqResource;
use App\Http\Controllers\Api\vendor\RfqController;
use App\Http\Controllers\Dentist\ProductController;
use App\Http\Controllers\Api\Dentist\CardController;
use App\Http\Controllers\Api\Dentist\CartController;
use App\Http\Controllers\Api\Dentist\HomeController;
use App\Http\Controllers\Dentist\EmployeeController;
use App\Http\Controllers\Api\Dentist\OrderController;
use App\Http\Controllers\Api\vendor\BranchController;
use App\Http\Controllers\Api\vendor\CategoryController;
use App\Http\Controllers\Api\vendor\SubCategoryController;
use App\Http\Controllers\Api\Dentist\RfqController as DentistRfqController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware(['auth:sanctum'])->prefix('dentist')->group(function(){
    Route::get('home' , [HomeController::class, 'home']);
    Route::get('categories' , [HomeController::class, 'Categories']);
    Route::post('add-remove-fav/{id}' ,[HomeController::class, 'toggleFavorite']);
    Route::get('show-product/{id}' ,[HomeController::class, 'showProduct'])->name('products.show');

    Route::get('orders' , [OrderController::class, 'index']);
    Route::get('orders/{id}' , [OrderController::class, 'show']);
    Route::apiResource('rfqs' , DentistRfqController::class);
    Route::get('rfq-bids' , [DentistRfqController::class, 'bids']);
    Route::post('accept-rfq/{id}' , [DentistRfqController::class, 'AcceptBid']);
    Route::apiResource('cards' , CardController::class);
    Route::get('get-favs' , [HomeController::class, 'getFav']);
    Route::get('get-category-products' , [HomeController::class, 'getCategoryProducts']);
    Route::post('cancel-rfq/{id}', [DentistRfqController::class, 'CancelRfq']);
    Route::apiResource('products' , ProductController::class);
    Route::apiResource('employees' , EmployeeController::class);
    Route::apiResource('branches' , BranchController::class);
    Route::get('statistics' , [HomeController::class, 'statistics']);

    Route::middleware(['web'])->prefix('cart')->group(function(){

    Route::post('add-to-cart', [CartController::class, 'addToCart']);
    Route::post('update-cart', [CartController::class, 'updateCart']);
    Route::delete('cart-remove/{productId}', [CartController::class, 'removeFromCart']);
    Route::get('get-cart', [CartController::class, 'viewCart']);
    Route::post('checkout' , [OrderController::class, 'checkout']);

});


});
