<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NewsTranslation extends Model
{
	protected $table = 'news_translations';
	public $timestamps = false;

	protected $casts = [
		'news_id' => 'int'
	];

	protected $fillable = [
		'news_id',
		'title',
		'description',
		'locale'
	];

	public function news()
	{
		return $this->belongsTo(News::class);
	}
}
