<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('sliders')) {

            Schema::create('sliders', function (Blueprint $table) {
                $table->id();
                $table->string('link');
                $table->enum('status' ,['active','inactive']);
                $table->timestamps();
            });
        }


        if (!Schema::hasTable('slider_translations')) {
        Schema::create('slider_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('slider_id')->constrained('sliders')->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('locale');
            $table->string('title');
            $table->text('describtion');
            $table->unique(['slider_id','locale']);
        });
    }
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sliders');
    }
};
