<?php

namespace App\Http\Requests;

use App\Models\PageTranslation;
use App\Rules\UniqueTranslation;
use App\Traits\TranslatedAttributes;
use Illuminate\Foundation\Http\FormRequest;

class PageRequest extends FormRequest
{

    use TranslatedAttributes;

    private $translatedAttributes;
    private $translatedAttributesNames;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('page');

        $this->translatedAttributes = $this->translatedAttributes([
            'title' => ['required', 'string', 'max:255'],
            'describtion' => ['required', 'string', 'max:1024']
        ]);


        return [
                ...$this->translatedAttributes
        ];
    }

    public function attributes()
    {
        $this->translatedAttributesNames = $this->translatedAttributesNames($this->translatedAttributes);

        return [
            ...$this->translatedAttributesNames
        ];
    }
}
