<?php

namespace App\Http\Resources\Admin;

use App\Http\Resources\CurrencyResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ExchangeRateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'base_currency' => CurrencyResource::make($this->baseCurrency),
            'to_currency' => CurrencyResource::make($this->toCurrency),
            'rate' => $this->rate,
        ];
    }
}
