<?php

namespace App\Http\Resources\Api\Dentist;

use App\helpers\Attachment;
use App\Http\Resources\Api\Admin\CategoryResource;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'category_hierarchy' => $this->when($request->routeIs('products.show'), CategoryResource::collection($this->getCategoryHierarchy())), // Full category hierarchy
            'image' => MediaResource::make($this->image),
            'price' => Attachment::convertPrice($this->price),
            'specs' => $this->specs,
            'main_category' => [
                'id' => $this->mainCategory->id,
                'name' => $this->mainCategory->name,

            ],
            'sub_category' => [
                'id' => $this->subCategory?->id,
                'name' => $this->subCategory?->name,

            ],
            'is_fave' => $this->IsFav,
            'is_in_cart' => $this->is_in_cart

            // 'created_at' => $this->created_at->toDateTimeString(),
            // 'updated_at' => $this->updated_at->toDateTimeString(),
        ];
    }

    /**
     * Get the full category hierarchy starting from the main category to the subcategory.
     */
    private function getCategoryHierarchy()
    {
        $categories = [];

        // If sub_category_id is null, return only the main category
        if (is_null($this->sub_category_id)) {
            if ($this->mainCategory) {
                $categories[] = $this->mainCategory;
            }
        } else {
            // Start with the subcategory (the lowest child)
            $currentCategory = $this->subCategory;

            // Traverse up to the top parent
            while ($currentCategory) {
                $categories[] = $currentCategory; // Add the current category to the list
                $currentCategory = $currentCategory->parent; // Move to the parent
            }

            // Reverse the categories array to have the highest parent first
            $categories = array_reverse($categories);
        }

        return $categories;
    }
}
