<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'product_id' => $this->product_id,
            'product_name' => $this->product->name,
            'product_image' => MediaResource::make($this->product->image),
            'quantity' => $this->qty,
            'price' => $this->product->price,
            'specs' => json_decode($this->specs), // Decode specs from JSON to array
        ];
    }
}
