<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CategoryTranslation extends Model
{
    use HasFactory;

    protected $table = 'city_translations';

	protected $casts = [
		'category_id' => 'int'
	];

    protected $fillable = ['category_id', 'name', 'locale'];


    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

}
