<?php

namespace App\Traits;

use Symfony\Component\HttpFoundation\Response;

trait PaginatedResponse
{

    // this function generates a paginated data response
    // it takes the records query as first arguement and the the resource of returned model as second arugment
    public function paginatedResponse($recordsQuery, $modelResource = null, $model = null, $code   = null)
    {
        if (!$modelResource) {
            $modelResource = $this->resource ?? $model;
        }

        $page = request('page') ?? 1;
        $itemsPerPage = request('per_page') ?? 10;

        $paginator = $recordsQuery->paginate(perPage: $itemsPerPage, page: $page);
        $items = $modelResource::collection($paginator->items());

        return response()->json([
            'status' => Response::HTTP_OK,
            'message' => 'success',
            'code' => $code,
            'meta' => [
                'total' => $paginator->total(),
                'per_page' => $paginator->perPage(),
                'current_page' => $paginator->currentPage(),
                'last_page' => $paginator->lastPage(),
            ],
            'data' => $items

        ]);
    }

    // public function getPaginatedData($recordsQuery, $modelResource)
    // {
    //     $page = request('page') ?? 1;
    //     $itemsPerPage = request('per_page') ?? 10;

    //     $paginator = $recordsQuery->paginate(perPage: $itemsPerPage, page: $page);
    //     $items = $modelResource::collection($paginator->items());

    //     return [
    //         'meta' => [
    //             'total' => $paginator->total(),
    //             'per_page' => $paginator->perPage(),
    //             'current_page' => $paginator->currentPage(),
    //             'last_page' => $paginator->lastPage(),
    //         ],
    //         'data' => $items
    //     ];
    // }


    public function OutCrudpaginatedResponse($recordsQuery, $modelResource = null)
    {
        if (!$modelResource) {
            $modelResource = $this->resource;
        }

        // Check if $recordsQuery is an array
        if (is_array($recordsQuery)) {
            // Extract data from the array if available
            $data = $recordsQuery['data'] ?? [];
            $total = $recordsQuery['total'] ?? null;
            $perPage = $recordsQuery['per_page'] ?? null;
            $currentPage = $recordsQuery['current_page'] ?? null;
            $lastPage = $recordsQuery['last_page'] ?? null;
        } else {
            // If $recordsQuery is not an array, assume it's a paginated result
            $paginator = $recordsQuery->paginate();
            $data = $modelResource::collection($paginator->items());
            $total = $paginator->total();
            $perPage = $paginator->perPage();
            $currentPage = $paginator->currentPage();
            $lastPage = $paginator->lastPage();
        }

        return response()->json([
            'status' => Response::HTTP_OK,
            'message' => 'success',
            'code' => '',
            'meta' => [
                'total' => $total,
                'per_page' => $perPage,
                'current_page' => $currentPage,
                'last_page' => $lastPage,
            ],
            'data' => $data,
        ]);
    }
}
