<?php

namespace App\Exports;

use App\Models\User;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;

class UserExport implements FromCollection, WithHeadings , WithEvents
{
    protected $type;

    // Constructor to accept type
    public function __construct($type)
    {
        $this->type = $type;
    }

    /**
     * @return Collection
     */
    public function collection()
    {
        // Fetch users based on the provided type
        return User::where('type', $this->type)
            ->with(['country'])
            ->get()
            ->map(function ($user) {
                return [
                    'ID' => $user->id,
                    'Owner Name' => $user->owner_name,
                    'Email' => $user->email,
                    'Mobile' => $user->mobile,
                    'Type' => $user->type,
                    'Country' => $user->country?->name,
                    'Product Access' => $user->product_access ?? 'forbidden',
                    'Status' => $user->status,
                ];
            });
    }

    /**
     * Define column headings
     *
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Owner Name',
            'Email',
            'Mobile',
            'Type',
            'Country',
            'Product Access',
            'Status',
            'Country',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet;

                // Auto-size each column
                foreach (range('A', 'I') as $column) {
                    $sheet->getDelegate()->getColumnDimension($column)->setAutoSize(true);
                }
            },
        ];
    }
}
