<?php

namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'description' => ['sometimes', 'string'],
            'main_category_id' => ['required', 'integer', 'exists:categories,id'],
            'sub_category_id' => ['sometimes', 'integer', 'exists:categories,id'],
            'image' => ['nullable', 'image', 'max:2048'],
            'specs' => ['nullable', 'array'],
            'price' => ['sometimes', 'numeric' , 'min:0'],
            'specs.*.key' => ['required_with:specs', 'string', 'max:255'],
            'specs.*.value' => ['required_with:specs', 'string', 'max:255'],
        ];
    }

}
