<?php

namespace App\Traits;

trait Searchful
{
    // returns search query based on request parameters
    public function search()
    {
        $model = new $this->model;
        $recordQuery = $this->model::query();
        foreach (request()->all() as $key => $value) {
            if ($model->searchableFields && in_array($key, array_keys($model->searchableFields))) {


                $recordQuery->where(function ($query) use ($model, $key, $value) {
                    foreach ($model->searchableFields[$key] as $column => $method) {
                        if ($method == 'LIKE') {
                            if ($key === 'status') {
                                // Check if the value is explicitly set to 'false'
                                if ($value === 'false' || $value === false) {
                                    // If the value is 'false', search for 'Inactive'
                                    $query->where('status', 'Inactive');
                                } else {
                                    // Otherwise, search for 'Active'
                                    $query->where('status', 'Active');
                                }

                            }
                            $query->orWhere($column, 'LIKE', "%$value%");
                        } else {
                            $query->orWhere($column, $value);
                        }
                    }
                });


            }

            if ($model->searchableRelations && in_array($key, array_keys($model->searchableRelations))) {

                $modelize = str_replace(' ', '', ucwords(str_replace('_', ' ', $key)));
                $relation_class = "App\Models\\$modelize\\$modelize";

                $relation_name = $model->searchableRelations[$key];

                $key_record = $relation_class::find($value);

                $ids = $key_record ? $key_record->$relation_name->pluck('id')->toArray() : [];

                $recordQuery->whereIn('id', $ids);
            }

            // Check if the key is 'status'

        }


        return $recordQuery;
    }

}
