<?php

namespace Database\Seeders;

use App\Models\RFQ;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class RFQSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Define the RFQs and associated specs
        $rfqs = [
            [
                'product_id' => 1,
                'branch_id' => 1,

                'qty' => 10,
                'specs' => [1, 2]  // Specify related spec IDs here
            ],
            [
                'product_id' => 2,
                'branch_id' => 1,
                'qty' => 5,
                'specs' => [3, 4]  // Specify related spec IDs here
            ],
        ];

        // Loop through each RFQ
        foreach ($rfqs as $rfqData) {
            // Extract specs and remove from data
            $specs = $rfqData['specs'];
            unset($rfqData['specs']);

            // Create the RFQ
            $rfq = RFQ::create($rfqData);

            // Attach specs to the RFQ using the belongsToMany relationship
            $rfq->specs()->attach($specs);
        }
    }
}
