<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\EmployeeRequest;
use App\Http\Resources\Api\Admin\EmployeeResource;

class EmployeeController extends Controller
{
    use HasCrudActions;


    protected $model = User::class;

    protected $resource = EmployeeResource::class;

    protected $request = EmployeeRequest::class;



    public function index(Request $request)
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading

        $modelResource = $this->search()->where('type' , 'employee')->where('vendor_id',$request->user_id)->with('EmBranch:id,name' , 'vendor:id,owner_name');

        return $this->apiResponse('200', __('success'), '', EmployeeResource::collection($modelResource->orderBy('id', 'DESC')->get()));



    }
}
