<?php

namespace App\Http\Requests\Api\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation()
    {
        $this->merge([
            'country_id' => $this->input('country_id', 1), // Set default value to 1 if not provided
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('user');  // Get user id from route (for update)
        $isUpdate = $this->isMethod('put') || $this->isMethod('patch');  // Check if it's an update request

        return [
            'owner_name' => [$isUpdate ? 'sometimes' : 'required', 'string', 'max:255'],  // Always required
            'email' => [$isUpdate ? 'sometimes' : 'required', 'email', 'unique:users,email,' . $id],  // Optional on update
            'password' => [$isUpdate ? 'sometimes' : 'required', 'confirmed', 'min:5', 'max:20'],  // Optional on update
            'country_code' => [$isUpdate ? 'sometimes' : 'required'],  // Always required
            'mobile' => [$isUpdate ? 'sometimes' : 'required'],  // Always required
            'image' => ['sometimes', 'mimes:jpg,jpeg,png'],  // Optional on update
            'type' => [$isUpdate ? 'sometimes' : 'required', 'in:dentist,vendor'],  // Always required
            'bank_account' => 'sometimes|string|max:255',  // Optional on update
            'bank_holder_name' => 'sometimes|string|max:255',  // Optional on update
            'bank_number' => 'sometimes|string|max:255',  // Optional on update
            'swift_code' => 'sometimes|string|max:255',  // Optional on update
            'iban' => 'sometimes|string|max:255',  // Optional on update,
            'product_access' => 'sometimes',
            'status' => 'sometimes|in:Active,Blocked'
        ];
    }
}
