<?php

namespace App\Http\Requests\Api\vendor;

use Illuminate\Foundation\Http\FormRequest;

class BidRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'vendor_id' => auth()->user()->id, // Set default value to 1 if not provided

        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'price' => 'required|min:0|numeric',
            'rfq_id' => 'required|exists:r_f_q_s,id'
        ];
    }
}
