<?php

namespace App\Http\Resources\Api\Admin;

use App\Http\Resources\MediaResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\helpers\Attachment;

class BidResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'rfq_id' => $this->rfq_id,
            'qty' => $this->rfq->qty,
            'price' => Attachment::convertPrice($this->price),
            'vendor' => [
                'id' => $this->vendor->owner_name,
                'name' => $this->vendor->owner_name,
            ],
            'product' => [
                'id' => $this->rfq->product->id,
                'name' => $this->rfq->product->name,
                'image' => MediaResource::make($this->rfq->product->image),
            ],
            'created_at' => Carbon::parse($this->created_at)->format('y-m-d h:i:s'),

        ];
    }
}
