<?php

namespace App\Http\Resources\Api\Admin;

use App\Models\Category;
use App\helpers\Attachment;
use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Requests\Api\vendor\SubCategoryRequest;

class ProductResource extends JsonResource
{   
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'main_category' => CategoryResource::make($this->whenLoaded('mainCategory')),
            'sub_category' => SubCategoryResource::make($this->whenLoaded('subCategory')),
            'category_hierarchy' => $this->when($request->routeIs('products.show') , CategoryResource::collection($this->getCategoryHierarchy())), // Full category hierarchy

            'image' => MediaResource::make($this->image),
            'price' =>Attachment::convertPrice( $this->price),

            'specs' => $this->specs,
            'created_at' => $this->created_at->toDateTimeString(),
            'updated_at' => $this->updated_at->toDateTimeString(),
        ];
    }

    private function getCategoryHierarchy($maxDepth = 10)
    {
        $categories = [];
        $currentDepth = 0;

        // Start with the subcategory (the lowest child)
        $currentCategory = $this->subCategory;

        // Traverse up to the top parent, limited by maxDepth
        while ($currentCategory && $currentDepth < $maxDepth) {
            $categories[] = $currentCategory; // Add the current category to the list
            $currentCategory = $currentCategory->parent; // Move to the parent
            $currentDepth++; // Increase the depth counter
        }

        // Reverse the categories array to have the highest parent first
        return array_reverse($categories);
    }
    
}
