<?php

namespace App\Http\Resources\Api;

use App\Http\Resources\Api\Client\BranchResource;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'owner_name' => $this->owner_name,
            'mobile' => $this->mobile,
            'country_code' => $this->country_code,
            'email' => $this->email,
            'branches' => BranchResource::collection($this->whenLoaded('branches')),
            'image' => MediaResource::make($this->image),
            'product_access' => $this->product_access,
            'banckAccount' => $this->whenLoaded('bankAccount')

        ];
    }
}
