<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class BlogCategoriesTranslation extends Model
{
	protected $table = 'blog_categories_translations';
	public $timestamps = false;

	protected $casts = [
		'blog_category_id' => 'int'
	];

	protected $fillable = [
		'blog_category_id',
		'title',
		'locale'
	];

	public function blog_category()
	{
		return $this->belongsTo(BlogCategory::class);
	}
}
