<?php

namespace App\Models;

use App\Models\RFQ;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = ['name' , 'mobile' , 'country_code' , 'location' , 'city_id' , 'governerate_id' , 'user_id'];
    protected $withRelations = ['governorate', 'city' , 'user'];


    public function getWithRelations()
{
    return $this->withRelations;
}



    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function governorate(){
        return $this->belongsTo(Governerate::class , 'governerate_id');
    }

    public function user(){
        return $this->belongsTo(User::class , 'user_id');
    }

    public function rfq()
    {
        return $this->belongsTo(RFQ::class ,'branch_id');
    }
}
