<?php


namespace App\Models;

use Carbon\Carbon;
use App\Traits\GetAttribute;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Category extends Model
{
    use  GetAttribute;
	protected $table = 'categories';


    protected $fillable = ['parent_id','name' , 'main_category_id'];
    protected $withRelations = ['children'];


    public function getWithRelations()
{
    return $this->withRelations;
}


    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->multiple_attachment = true;
        $this->multiple_attachment_usage = ['default', 'bdf-file'];
    }


    public function getImageAttribute()
    {
        return $this->attachmentRelation()->first();
    }

    public function children(): HasMany
    {
        return $this->hasMany(Category::class, 'parent_id');
    }



    public function products(): HasMany
    {
        return $this->hasMany(Product::class, 'main_category_id');
    }

    public function subCategoryProducts(): HasMany
    {
        return $this->hasMany(Product::class, 'sub_category_id');
    }

    public function MainCategory(){
        return $this->belongsTo(Category::class,'main_category_id');
    }


}
