<?php

namespace App\Traits;

use App\Models\Admin\Admin;
use App\Models\History\History;
use App\Models\User\User;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Str;

trait HistoryCreator
{
  
    public function createHistory($model_type, $model_id, $action , $user_id = null)
    {
        $model_arr = explode('\\', $model_type);
        $model_name = str_replace(' ', '_', strtolower(Str::headline($model_arr[count($model_arr)-1])));
        History::create([
            'model_type' => $model_type,
            'model_id' => $model_id,
            'user_type' => App::runningInConsole() ? Admin::class : (request()->user() ? request()->user()::class : User::class),
            'user_id' =>  App::runningInConsole() ? rand(1,5) : (auth()->id() ?? $user_id),
            'ip_address' => request()->ip(), // Get the IP address
            'ar' => ['message' => __("main.history_$action", ['model' => __("main.$model_name", [], 'ar'), 'user' => App::runningInConsole() ? fake()->userName() : (request()->user() ? request()->user()->username : 'user_payment')], 'ar')],
            'en' => ['message' => __("main.history_$action", ['model' => __("main.$model_name", [], 'en'), 'user' => App::runningInConsole() ? fake()->userName() : (request()->user() ? request()->user()->username : 'user_payment')], 'en')],
        ]);
    }
}
