<?php 

namespace App\Traits;

trait TranslatedAttributes {

    // this function takes an associative array of attributes and rules. it adds the language prefix and make the default language required nad the others nullable.
    public function translatedAttributes($rules){
        $translated_attributes = [];
        $defaultLocale = app()->getLocale();

        foreach(config('translatable.locales') as $locale){
            foreach($rules as $attribute => $rule){
                $newRule = $rule;  // created new variable so that we don't change the original array when removing 'required' attribute from the it.

                if($locale != $defaultLocale){      
                    $requiredFieldIndex = array_search('required', $newRule);
                    
                    if($requiredFieldIndex !== false){
                        $newRule[$requiredFieldIndex] = 'nullable';
                    }
                }

                $translated_attributes["$locale.$attribute"] = $newRule;
            }
        }
    
        return $translated_attributes;
    }

    // this function takes the associative array of the translated attributes and returns the display attribute names for them.
    public function translatedAttributesNames($attributes){
        $attributes = array_keys($attributes);
        $names = [];
        
        foreach($attributes as $attribute){
            [$locale, $attr] = explode('.', $attribute);
            
            $names["$attribute"] = __("attributes.$attr") . " " . __("attributes.in_$locale");
        }
        
        return $names;
    }



}