<?php

namespace App\Helpers;

use App\Models\Setting;
use App\Models\ExchangeRate;

class Convert
{
    /**
     * Convert a given price using the default currency exchange rate.
     *
     * @param float $price
     * @param int|null $toCurrencyId Optional currency ID to convert to. Defaults to default currency.
     * @return float
     */
    public static function convertPrice(float $price, ?int $currencyId = null): float
    {
        // Fetch the default currency ID from settings if not provided
        static $defaultCurrencyId = null;
        if ($defaultCurrencyId === null) {
            $defaultCurrencyId = Setting::first()->currency_id;
        }

        // Determine the target currency ID
        $currencyId = $currencyId ?? $defaultCurrencyId;

        // Fetch the exchange rate for the given currency
        static $exchangeRates = [];
        if (!isset($exchangeRates[$currencyId])) {
            $exchangeRates[$currencyId] = ExchangeRate::where('to_currency_id', $currencyId)
                ->value('rate') ?? 1; // Default rate to 1 if not found
        }

        // Convert the price and return the rounded value
        return round($price * $exchangeRates[$currencyId], 2);
    }
}
