<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{ 
    public function up(): void
    {
        if (!Schema::hasTable('logs')) {
            Schema::create('logs', function (Blueprint $table) {
                $table->id();
                $table->string('user_type')->nullable();
                $table->bigInteger('user_id')->nullable();
                $table->string('model_type')->nullable();
                $table->bigInteger('model_id')->nullable();
                $table->text('message');
                $table->timestamp('created_at');
                $table->softDeletes();
            });
        }
    }

    
    public function down(): void
    {
        Schema::dropIfExists('logs');
    }
};