<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->boolean('registeration_vendors')->default(true);
            $table->boolean('registeration_clinics')->default(true);
            $table->boolean('product_access')->default(true);
            $table->boolean('direct_orders')->default(true);
            $table->boolean('payment_methods')->default(true);
            $table->foreignId('currency_id')->nullable()->constrained()->cascadeOnDelete();
            $table->time('rfq_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
