<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
        public function up(): void
        {
            Schema::create('exchange_rates', function (Blueprint $table) {
                $table->id();
                $table->foreignId('base_currency_id')->constrained('currencies')->cascadeOnDelete();
                $table->foreignId('to_currency_id')->constrained('currencies')->cascadeOnDelete();
                $table->double('rate')->nullable();
                $table->timestamps();
            });
        }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchange_rates');
    }
};
