<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admin_notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sender_id')->nullable()->constrained('admins')->nullOnDelete(); // References admins table
            $table->string('title');
            $table->string('body');
            $table->enum('receivers_type', ['vendor', 'dentist', 'all' , 'user']); // Type of receivers
            $table->json('receiver_ids')->nullable(); // Store selected receiver IDs as a JSON array
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admin_notifications');
    }
};
