<?php

namespace App\Traits;

use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\App;

trait ErrorMessage {

    // return the the appropriate error message based on the exception type
    public function errorMessage($e)
    {
        if ($e::class == ValidationException::class) {
            return $this->apiResponse(Response::HTTP_UNPROCESSABLE_ENTITY, 'fail', collect($e->validator->errors()->getMessages())->flatten()->first(), ['errors' => $e->validator->errors()->getMessages()]);
        }

        return $this->apiResponse(Response::HTTP_INTERNAL_SERVER_ERROR, 'fail', App::environment('local') ? $e->getMessage() : __('messages.something_went_wrong'));
    }
}
