<?php

use App\Http\Controllers\Vendor\MessageController;
use App\Models\Country;
use Illuminate\Http\Request;
use App\Models\CountryTranslation;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;
use Spatie\Permission\Contracts\Role;
use App\Http\Resources\CountryResource;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ProfileController;
use App\Http\Controllers\Api\vendor\BranchController;
use App\Http\Controllers\Api\vendor\CategoryController;
use App\Http\Controllers\Api\vendor\EmployeeController;
use App\Http\Controllers\Api\vendor\ProductController;
use App\Http\Controllers\Api\vendor\RfqController;
use App\Http\Controllers\Api\vendor\SubCategoryController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->prefix('vendor')->group(function(){
    Route::apiResource('branches' , BranchController::class);
    Route::apiResource('employees' , EmployeeController::class);
    Route::apiResource('categories' , CategoryController::class);
    Route::apiResource('sub-categories' , SubCategoryController::class);
    Route::post('messages' , [MessageController::class , 'store']);
    Route::apiResource('products' , ProductController::class);
    Route::post('send-product-request' , [ProductController::class , 'SendAccessRequest']);
    Route::apiResource('rfqs' , RfqController::class);
    Route::post('add-bid', [RfqController::class , 'addBid']);
    Route::get('my-rfqs' , [RfqController::class  , 'myRfqs']);
    Route::get('statistcs', [RfqController::class , 'statistics']);


});
