<?php

namespace App\Http\Controllers\Api\vendor;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\vendor\SubCategoryRequest;
use App\Http\Resources\Api\vendor\SubCategoryResource;

class SubCategoryController extends Controller
{
    use HasCrudActions;

    protected $model = Category::class;

    protected $resource = SubCategoryResource::class;

    protected $request = SubCategoryRequest::class;

    public function index()
    {
        $modelResource = $this->search();

        return $this->ApiResponse('200', __('success'), '', SubCategoryResource::collection($modelResource->whereNotNull('parent_id')->orderBy('id' , 'DESC')->with('children')->get()));

    }
}
