<?php


namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class CityTranslation extends Model
{
	protected $table = 'city_translations';

	protected $casts = [
		'city_id' => 'int'
	];

	protected $fillable = [
		'city_id',
		'name',
		'locale'
	];

	public function country()
	{
		return $this->belongsTo(Country::class, 'city_id');
	}
}
