<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\BidController;
use App\Http\Controllers\Api\Admin\RfqController;
use App\Http\Controllers\Admin\ExchangeController;
use App\Http\Controllers\Api\Admin\PageController;
use App\Http\Controllers\Api\Admin\UserController;
use App\Http\Controllers\Vendor\MessageController;
use App\Http\Controllers\Api\Admin\OrderController;
use App\Http\Controllers\Api\Admin\BranchController;
use App\Http\Controllers\Api\Admin\ProductController;
use App\Http\Controllers\Api\Admin\SettingController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Api\Admin\CategoryController;
use App\Http\Controllers\Api\Admin\EmployeeController;
use App\Http\Controllers\Api\Admin\SubCategoryController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware(['auth:sanctum', 'check-admin' ,'locale'])->prefix('admin')->group(function () {
    Route::apiResource('users', UserController::class);
    Route::get('settings', [SettingController::class, 'index']);
    Route::post('update', [SettingController::class, 'update']);
    Route::apiResource('categories', CategoryController::class);
    Route::get('sub-categories/{id}/{main_category_id}', [SubCategoryController::class, 'show']);
    Route::apiResource('sub-categories', SubCategoryController::class);
    Route::apiResource('products', ProductController::class);
    Route::apiResource('pages', PageController::class);
    Route::apiResource('branches', BranchController::class);
    Route::get('branches', [BranchController::class, 'index']);
    Route::post('bank-info', [SettingController::class,'BankAccount']);
    Route::get('bank-info', [SettingController::class,'getBankData']);
    Route::apiResource('exchange-rate' , ExchangeController::class);
    Route::get('messages' ,[MessageController::class , 'index']);
    Route::get('index' , [NotificationController::class , 'index']);
    Route::post('send-notifications', [NotificationController::class,'sendNotification']);
    Route::apiResource('employees', EmployeeController::class)->except('index');
    Route::get('employees', [EmployeeController::class, 'index']);
    Route::apiResource('rfqs', RfqController::class);
    Route::apiResource('orders', OrderController::class);
    Route::apiResource('bids', BidController::class);
    Route::post('assign-order', [OrderController::class, 'assignOrder']);
    Route::get('product-requests', [UserController::class, 'productRequests']);
    Route::get('statistics' , [SettingController::class, 'statistics']);
    Route::get('products-by-vendor/{vendorId}', [ProductController::class, 'getVendorProducts']);
    Route::post('/import-products', [ProductController::class, 'import'])->name('import.products');

});
