<?php

namespace App\Http\Requests\Dentist;

use Illuminate\Foundation\Http\FormRequest;

class EmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation()
    {
        $this->merge([
            'country_id' => $this->input('country_id', 1), // Set default value to 1 if not provided
            'type' => $this->input('type', 'employee'), // Set default value to 1 if not provided
            'dentist_id' => auth()->user()->id
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $id = $this->route('employee');
        return [

            'owner_name' => ['required','string','max:255'],
            'email' => ['required','email','unique:users,email,'. $id],
            'password' => ['required','confirmed','min:5,max:20'],
            'role_name' => ['required','string'],
            'branch_id' => ['required' , 'exists:branches,id'],
            'country_id' => ['required', 'integer'], // Add country_id to the validation rules
        ];
    }
}