<?php

namespace App\Http\Controllers\Admin;

use App\Models\Currency;
use App\Traits\ApiResponse;
use App\Models\ExchangeRate;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Resources\Admin\ExchangeRateResource;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ExchangeController extends Controller
{
    use HasCrudActions;

    public function index()
    {
        $data = ExchangeRate::with(['baseCurrency', 'toCurrency'])
            ->get();
           
            
            return $this->apiResponse(Response::HTTP_OK, __('success'), __('Success'), ExchangeRateResource::collection($data));
        }

    public function show($id)
    {
        $exchangeRate = ExchangeRate::with([
            'baseCurrency',
            'toCurrency',
        ])->find($id);
            if(!$exchangeRate){
                return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource not found'));
            }
        return $this->apiResponse(Response::HTTP_OK, __('success'), __('Success') , new ExchangeRateResource($exchangeRate));

    }

    public function store(Request $request)
    {
        $request->validate([
            'to_currency_id' => 'required|array',
            'rates' => 'required|array',
            'to_currency_id.*' => 'required|exists:currencies,id',
            'rates.*' => 'required|numeric',
        ]);
    
        if (count($request->to_currency_id) !== count($request->rates)) {
            return response()->json([
                'message' => 'The number of to_currency_id and rates must match.'
            ], 422);
        }
    
        $baseCurrencyId = 97; // Replace with your dynamic value
        $toCurrencyIds = $request->to_currency_id;
        $rates = $request->rates;
    
        foreach ($toCurrencyIds as $index => $toCurrencyId) {
            // Use updateOrInsert to update existing records or create new ones
            ExchangeRate::updateOrInsert(
                [
                    'base_currency_id' => $baseCurrencyId,
                    'to_currency_id' => $toCurrencyId,
                ],
                [
                    'rate' => $rates[$index],
                    'updated_at' => now(),
                    'created_at' => now(),
                ]
            );
        }
    
        return $this->apiResponse(Response::HTTP_OK, __('success'), __('Success'));
    }
    

    public function update(Request $request, $baseCurrencyId)
    {
        $request->validate([
            'rates' => 'required|array',
            'rates.*.to_currency_id' => 'required|exists:currencies,id',
            'rates.*.rate' => 'required|numeric',
        ]);

        foreach ($request->rates as $rateData) {
            ExchangeRate::updateOrCreate(
                [
                    'base_currency_id' => $baseCurrencyId,
                    'to_currency_id' => $rateData['to_currency_id'],
                ],
                ['rate' => $rateData['rate']]
            );
        }

        return response()->json([
            'message' => 'Exchange rates updated successfully.',
        ]);
    }

    public function destroy($id)
    {
        $exchangeRate = ExchangeRate::findOrFail($id);
        $exchangeRate->delete();

        return $this->apiResponse(Response::HTTP_OK, __('success'), __('deleted successfully'));
    }
}
