<?php

namespace App\Listeners;

use App\Events\UserRegistered;
use App\Mail\VerificationCodeMail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendVerificationCode
{
    public function __construct()
    {
        //
    }

    public function handle(UserRegistered $event)
    {
        // Generate verification code
        $verificationCode = rand(1000, 9999);
        DB::table('password_reset_codes')->insert([
            'type' => $event->user::class,
            'email' => $event->user->email,
            'code' => $verificationCode,
            'created_at' => now()
        ]);

        // Save the verification code to the user model or a separate table

        // Send the verification code to the user's email
        Mail::to($event->user->email)->send(new VerificationCodeMail($verificationCode));
    }
}
