<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('governorates')) {
            Schema::create('governorates', function (Blueprint $table) {
                $table->id();
                $table->foreignId('country_id')->constrained('countries')->cascadeOnDelete()->cascadeOnUpdate();
                $table->enum('status', ['active', 'inactive'])->default('active');
                $table->timestamps();
                $table->softDeletes();
            });
        }

        if (!Schema::hasTable('governorate_translations')) {
            Schema::create('governorate_translations', function (Blueprint $table) {
                $table->id();
                $table->foreignId('governerate_id')->constrained('governorates')->cascadeOnDelete()->cascadeOnUpdate();
                $table->string('name');
                $table->string('locale');
                $table->unique(['governerate_id', 'locale']);
                $table->timestamps();

            });
        }
    }


    public function down(): void
    {
        Schema::dropIfExists('governorates');
        Schema::dropIfExists('governorate_translations');
    }
};
